function [ x, xOffsets, yTrain, yTest, corrs, longCorr, rmse ] = prepareMultiData( dim, dimLabels, ccrfFolder, exts )
%PREPAREMULTIDATA Summary of this function goes here
%   Detailed explanation goes here

    nums = zeros(size(exts));
    for i = 1:numel(nums)
        infile = [ccrfFolder exts{i} dimLabels{1} '.mat'];
        load(infile);   
        nums(i) = size(dataMat,1);

        numRegressors = size(dataMat,2) - 1;
    end
    
    totalNumSeqs = sum(nums);
    numDims = numel(dimLabels);
    
    data = cell(totalNumSeqs, 2 * numRegressors * numDims + 1);
    
    corrs = zeros(totalNumSeqs, numDims * 2);
        
    currSeq = 1;
    for i=1:numel(exts)
        
        for dims=1:numel(dimLabels)

            infile = [ccrfFolder exts{i} dimLabels{dims} '.mat'];
            load(infile);   

            data(sum(nums(1:i-1))+1:sum(nums(1:i)),2+(dims-1)*numRegressors:1+dims*numRegressors) = dataMat(:,2:end);
            if(dims == dim)
                data(sum(nums(1:i-1))+1:sum(nums(1:i)),1) = dataMat(:,1);
            end

        end
        currSeq = currSeq + 1;
    end
    
    % in order to capture negative correlations have to add negative
    % values
    for i=1:size(data,1)
        for j=numRegressors*numel(dimLabels) + 2:size(data,2)            
            data{i,j} = -data{i,j - numRegressors*numel(dimLabels)};
        end
    end
    
    yCat = [];
    xCats = [];
    
    for i=1:size(data,1)
        xCat = zeros(size(data{i,1},1), 2 * numRegressors * numDims);
        for j=2:size(data,2)
                                
            if(numel(data{i,1}) > numel(data{i,j}))
                xCat(:,j-1) = [data{i,j};zeros(numel(data{i,1}) - numel(data{i,j}),1)];
            elseif(numel(data{i,1}) < numel(data{i,j}))
                xCat(:,j-1) = data{i,j}(1:end - (numel(data{i,j}) - numel(data{i,1})));                
            else
                xCat(:,j-1) = data{i,j};
            end
            
            corrs(i,j-1) = corr(data{i,1}, xCat(:,j-1));
            
        end
        xCats = cat(1, xCats, xCat);
        yCat = cat(1, yCat, data{i,1});
    end
    
    longCorr = zeros(1, 2 * numRegressors * numDims);

    for i=1:2 * numRegressors * numDims
        longCorr(i) = corr(yCat, xCats(:,i));
    end

    rmse = sqrt( (1/numel(yCat)) * sum((xCats - repmat(yCat,1,size(xCats,2))).^2) );

    [x, ~, yTrain, yTest] = prepareData(data); 
    [~,xOffsets, ~,~] = prepareData([data(:,1), data(:,2+(dim-1)*numRegressors:1+(dim)*numRegressors)]);

end

